-- ANMERKUNG: siehe "Y TWawi.Views.Auftrag.sql"

--
CREATE OR REPLACE FUNCTION TSystem.views__Wawi_Eingangsrechnung__recreate() RETURNS VOID AS $$
  BEGIN
    -- Bestehende-Views droppen
        DROP VIEW IF EXISTS TWawi.erechnung_posext;
        DROP VIEW IF EXISTS TWawi.erechnung_pos;
    --
    
    -- Basis-View => Updatable, da kann man reinschreiben. Nur Felder aus Basistabelle, keine NULLs, keine Funktionen, keine Felder anderer Tabellen.
    CREATE OR REPLACE VIEW TWawi.erechnung_pos AS
      SELECT
      -- Identifikatoren
        dbrid               AS dbrid                   ,--
        belp_id             AS p_id                    ,-- ID der Pos.
        --                  AS p_dokunr                ,-- Referenz auf das zug. Dokument
        belp_belegtyp       AS p_code                  ,-- Code / Klassifikation / Belegtyp
        --                  AS p_nummer                ,-- Belegnummer
        belp_pos            AS p_pos                   ,-- Positionsnummer
        belp_hauptpos       AS p_parent                ,-- Übergeordnete Position (Strukt. Belege)
        --                  AS p_table                 ,-- Tabelle aus der die Position stammt
      -- Artikeldaten
        belp_aknr           AS p_aknr                  ,-- Artikelnummer
        --                  AS p_aknr_idx              ,-- Artikelindex
        belp_akbez          AS p_akbez                 ,-- Überschriebene Artikelbezeichnung (wenn <> art.ak_bez)
        belp_referenzaknr   AS p_aknr_referenz         ,-- Referenzierte Artikelnummer (z.Bsp. Von Kunde oder Lieferant)
        belp_menge          AS p_menge                 ,-- Menge in Positions-ME
        belp_mce            AS p_me                    ,-- artmgc.m_id der Positions-ME
        --                  AS p_los                   ,-- Losgröße für Artikel
        belp_menge_gme      AS p_menge_gme             ,-- Menge in GME
        --                  AS p_mengeb_gme            ,-- Menge bestellt in GME
        --                  AS p_mengel_gme            ,-- Menge geliefert in GME
        --                  AS p_mengef_gme            ,-- Menge fakturiert in GME
        --                  AS p_mengeo                ,-- Offene Menge
        --                  AS p_mengeo_gme            ,-- Offene Menge in GME
        --                  AS p_norm                  ,-- Artikelnorm
        belp_kostenstelle   AS p_ks                    ,-- Zugeordnete Kostenstelle
        --                  AS p_gme                   ,-- artmgc.m_id der Grundmengeneinheit
        --                  AS p_mec                   ,-- ME-Code der Positions-ME
        --                  AS p_gmec                  ,-- ME-Code der Grund-ME
        --                  AS p_meuf                  ,-- Umrechnungsfaktor von Pos.ME zu GME
      -- Preisdaten
        belp_preis          AS p_preis                 ,-- Preis pro ME (enthält Preiseinheit)
        belp_preiseinheit   AS p_preiseinheit          ,-- Menge auf die sich p_preis bezieht
        --                  AS p_preis_me              ,-- Preis pro ME
        belp_preis_basis_w  AS p_preis_gwaer           ,-- Preis pro ME in Grundwährung
        belp_preis_gme      AS p_preis_gme             ,-- Preis pro GME
        belp_preis_gme_basis_w AS p_preis_gme_gwaer    ,-- Preis pro GME in Grundwährung
        belp_waehr          AS p_waer                  ,-- Pos. Währungseinheit
        belp_kurs           AS p_kurs                  ,-- Pos. Kurs zur Basiswährung
        belp_steucode       AS p_scode                 ,-- Steuercode
        belp_steuproz       AS p_sproz                 ,-- Steuerprozentsatz
        belp_rabatt         AS p_rabatt                ,-- Rabattsatz (0...100)
        belp_rabattfaehig   AS p_CanRabatt             ,-- Kennzeichen Rabattfähig
      -- Adressdaten
        belp_krzbesteller   AS p_adkrz                 ,-- Adresskürzel (Kunde o. Lieferant)
        belp_krzlieferung   AS p_adkrzl                ,-- Adresskürzel Lieferadresse
        belp_krzrechnung    AS p_adkrzf                ,-- Adresskürzel Rechnungsadresse
        --                  AS p_apext                 ,-- Kürzel Ansprechpartner extern
        --                  AS p_apextname             ,-- Voller Name Ansprechpartner extern
        --                  AS p_apint                 ,-- Kürzel Ansprechpartner intern
        --                  AS p_apintname             ,-- Voller Name Ansprechpartner intern
      -- Termine und Status
        insert_date         AS p_datum_eingang         ,-- Eingangsdatum
        belp_erstelldatum   AS p_datum_erfasst         ,-- Erfassdatum
        --                  AS p_datum_soll            ,-- Wunschdatum          -- belp_termin ? nie gefüllt
        --                  AS p_datum_ist             ,-- Bestätigtes Datum    -- belp_termin_bestaetigt, belp_termin_verschoben ? nie gefüllt
        --                  AS p_datum_istsoll         ,-- COALESCE(Bestätigtes, Wunschdatum)
        --                  AS p_datum_fibu_buchung    ,-- Datum des Exports in die Buchhaltungsschnittstelle
        --                  AS p_datum_storniert       ,-- Datum an dem die Pos. Storniert wurde
        --                  AS p_definitiv             ,-- Kennzeichen Pos. Definitiv
        belp_erledigt       AS p_done                  ,-- Kennzeichen Pos. Erledigt
        belp_storniert      AS p_storniert             ,-- Kennzeichen Pos. Storniert
        --                  AS p_IsBedarf              ,-- Kennzeichen bedarfswirksam
        --                  AS p_IsFertigung           ,-- Kennzeichen Fertigungsartikel
        --                  AS p_IsUmsatz              ,-- Kennzeichen umsatzwirksame Position
        --                  AS p_status                ,-- Allg. Status1
        --                  AS p_status1               ,-- Allg. Status2
        --                  AS p_status2               ,-- Allg. Status3
      -- Referenzen / Struktur
        --                  AS p_rahmen_id             ,-- p_ID des Rahmens oder Rahmenvertragsnummer
        --                  AS p_vorgaenger_table      ,--
        --                  AS p_vorgaenger_id         ,--
        belp_referenz       AS p_refnummer             ,-- Referenz auf ext.Nummer (Z.Bsp. Bestell-Nr. Kunde)
        --                  AS p_refpos                ,-- Referenz auf ext.Position (Z.Bsp. Bestellpos. - Kunde)
        belp_projektnummer  AS p_an_nr                 ,-- Projektnummer
        --                  AS p_vtp_id                ,-- ID der zugehörigen Vertragsposition
        --                  AS p_ab_ix                 ,-- Zugehörige ABK
        --                  AS p_q_nr                  ,-- QAB-Bezug
      -- Erweiterte Positionsdaten
        belp_konto          AS p_Konto                 ,--
        belp_dokutxt        AS p_txt_ext               ,--
        belp_dokutxt_rtf    AS p_txt_ext_rtf           ,--
        belp_txt            AS p_txt_int               ,--
        belp_txt_rtf        AS p_txt_int_rtf            --
      FROM eingrech_pos -- ist auch updateable view
    ;
    
    -- Erweiterter Anzeige-View => Nur lesbar. Felder aus Basis-View und angejointen Tabellen.
    CREATE OR REPLACE VIEW TWawi.erechnung_posext AS
      SELECT
      -- Identifikatoren
        pos.dbrid           AS dbrid                      ,--
        p_id                                              ,-- ID der Pos.
        beld_dokunr         AS p_dokunr                   ,-- Referenz auf das zug. Dokument
        p_code                                            ,-- Code / Klassifikation / Belegtyp
        beld_dokunr         AS p_nummer                   ,-- Belegnummer
        p_pos                                             ,-- Positionsnummer
        p_parent                                          ,-- Übergeordnete Position (Strukt. Belege)
        'eingrech_pos'::VARCHAR AS p_table                    ,-- Tabelle aus der die Position stammt
      -- Artikeldaten
        p_aknr                                            ,-- Artikelnummer
        COALESCE(ld_aknr_idx, ak_idx) AS p_aknr_idx       ,-- Artikelindex
        COALESCE(p_akbez, ak_bez) AS p_akbez              ,-- Überschriebene Artikelbezeichnung (wenn <> art.ak_bez)
        COALESCE(p_aknr_referenz, ld_bem)
                            AS p_aknr_referenz            ,-- Referenzierte Artikelnummer (z.Bsp. Von Kunde oder Lieferant)
        p_menge                                           ,-- Menge in Positions-ME
        p_me                                              ,-- artmgc.m_id der Positions-ME
        ak_los              AS p_los                      ,-- Losgröße für Artikel
        p_menge_gme                                       ,-- Menge in GME
        NULL::NUMERIC       AS p_mengeb_gme               ,-- Menge bestellt in GME
        NULL::NUMERIC       AS p_mengel_gme               ,-- Menge geliefert in GME
        NULL::NUMERIC       AS p_mengef_gme               ,-- Menge fakturiert in GME
        p_menge             AS p_mengeo                   ,-- Noch zu bestellende Menge
        p_menge_gme         AS p_mengeo_gme               ,-- Noch zu bestellende Menge in GME
        ak_norm             AS p_norm                     ,-- Artikelnorm
        p_ks                                              ,-- Zugeordnete Kostenstelle
      -- Mengeneinheitsdaten
        MEData.p_gme                                      ,-- Artmgc.m_id der Grundmengeneinheit
        MEData.p_mec                                      ,-- ME-Code der Positions-ME
        MEData.p_gmec                                     ,-- ME-Code der Grund-ME
        MEData.p_meuf                                     ,-- Umrechnungsfaktor Positions-ME zu Grund-ME
        MEData.p_meiso                                    ,-- ISO-Code der Positions-ME
        MEData.p_gmeiso                                   ,-- ISO-Code der Grund-ME
      -- Preisdaten
        p_preis                                           ,-- Preis pro ME (enthält Preiseinheit)
        p_preiseinheit                                    ,-- Menge auf die sich p_preis bezieht (4,99€ per 100Stk)
        belp_preis / Do1If0(p_preiseinheit) AS p_preis_me ,-- Preis pro ME
        p_preis_gwaer                                     ,-- Preis pro ME in Grundwährung
        p_preis_gme                                       ,-- Preis pro GME
        p_preis_gme_gwaer                                 ,-- Preis pro GME in Grundwährung
        p_waer                                            ,-- Pos. Währungseinheit
        p_kurs                                            ,-- Pos. Kurs zur Basiswährung
        p_scode                                           ,-- Steuercode
        p_sproz                                           ,-- Steuerprozentsatz
        p_rabatt                                          ,-- Rabattsatz (0...100)
        p_canRabatt                                       ,-- Kennzeichen Rabattfähig
        steu_txt            AS p_sbez                     ,-- Steuerbezeichnung
      -- Positionswerte
        belp_netto          AS p_wert_netto               ,-- Positionswert inkl. AbZuschläge, exkl. Steuern
        belp_brutto         AS p_wert_brutto              ,-- Positionswert inkl. AbZuschläge, inkl. Steuern
        belp_netto_basis_w  AS p_wert_netto_gwaer         ,-- Positionswert inkl. AbZuschläge, exkl. Steuern, in Grundwährung
        belp_brutto_basis_w AS p_wert_brutto_gwaer        ,-- Positionswert inkl. AbZuschläge, inkl. Steuern, in Grundwährung
      -- Adressdaten
        p_adkrz                                           ,-- Adresskürzel (Kunde o. Lieferant)
        p_adkrzl                                          ,-- Adresskürzel Lieferadresse
        p_adkrzf                                          ,-- Adresskürzel Rechnungsadresse
        beld_apkrzl         AS p_apext                    ,-- Kürzel Ansprechpartner extern
        beld_ap             AS p_apExtName                ,-- Voller Name Ansprechpartner extern
        beld_apint          AS p_apInt                    ,-- Kürzel Ansprechpartner intern
        nameAufloesen(beld_apint) AS p_apintname          ,-- Voller Name Ansprechpartner intern
      -- Termine und Status
        p_datum_eingang                                   ,-- Eingangsdatum
        p_datum_erfasst                                   ,-- Erfassdatum
        beld_erstelldatum + COALESCE(beld_zak, 0) AS p_datum_soll   ,-- Wunschdatum
        beld_erstelldatum + COALESCE(beld_zak, 0) AS p_datum_ist    ,-- Bestätigtes Datum
        beld_erstelldatum + COALESCE(beld_zak, 0) AS p_datum_istsoll,-- Eigentlicher Termin
        beld_exportdatum   AS p_datum_fibu_buchung        ,-- Datum des Exports in die Buchhaltungsschnittstelle
        NULL::DATE         AS p_datum_storniert           ,-- Datum an dem die Pos. Storniert wurde
        beld_definitiv     AS p_definitiv                 ,-- Kennzeichen Pos. Definitiv
        p_done                                            ,-- Kennzeichen Pos. Erledigt
        p_storniert                                       ,-- Kennzeichen Pos. Storniert
        true               AS p_IsBedarf                  ,-- Kennzeichen bedarfswirksame Position
        ak_fertigung       AS p_IsFertigung               ,-- Kennzeichen Fertigungsartikel (oder Fert.Position)
        true               AS p_IsUmsatz                  ,-- Kennzeichen umsatzwirksame Position
        NULL::VARCHAR      AS p_status                    ,-- Allg. Status1
        NULL::VARCHAR      AS p_status1                   ,-- Allg. Status2
        NULL::VARCHAR      AS p_status2                   ,-- Allg. Status3
      -- Referenzen / Struktur
        NULL::INTEGER      AS p_rahmen_id                 ,-- p_ID des Rahmens oder Rahmenvertragsnummer
        'ldsdok'::VARCHAR  AS p_vorgaenger_table          ,--
        belp_ld_id         AS p_vorgaenger_id             ,--
        p_refnummer                                       ,-- Referenz auf ext.Nummer   (Z.Bsp. Bestell-Nr.  Kunde)
        NULL::INTEGER      AS p_refpos                    ,-- Referenz auf ext.Position (Z.Bsp. Bestell-Pos. Kunde)
        p_an_nr                                           ,-- Projektnummer
        NULL::INTEGER      AS p_vtp_id                    ,-- ID der zugehörigen Vertragsposition
        NULL::INTEGER      AS p_ab_ix                     ,-- Zugehörige ABK
        NULL::INTEGER      AS p_q_nr                      ,-- QAB-Bezug
      -- Erweiterte Positionsdaten
        p_konto                                           ,-- Kontierung
        p_txt_ext                                         ,-- Positionstext extern
        p_txt_ext_rtf                                     ,--
        p_txt_int                                         ,-- Positionstext intern
        p_txt_int_rtf                                     --
      FROM TWawi.erechnung_pos AS pos
        JOIN eingrech_pos      ON belp_id = p_id
        JOIN eingrechdokument  ON beld_id = belp_dokument_id
        JOIN art               ON ak_nr   = p_aknr
        LEFT JOIN ldsdok       ON ld_id   = belp_ld_id
        LEFT JOIN steutxt      ON steu_z  = p_scode
        -- Informationen zur Mengenumrechnung mit aufnehmen
        , LATERAL( SELECT m2.m_id     AS p_gme,
                          m1.m_mgcode AS p_mec,
                          m2.m_mgcode AS p_gmec,
                          m1.m_uf     AS p_meuf,
                          lang_artmgc_id_iso(p_me)    AS p_meiso,
                          lang_artmgc_id_iso(m2.m_id) AS p_gmeiso
                   FROM art JOIN artmgc m1  ON (m1.m_ak_nr  = ak_nr) AND (m1.m_id = p_me)
                            JOIN artmgc m2  ON (m2.m_ak_nr  = ak_nr) AND (m2.m_mgcode = ak_standard_mgc)
                   WHERE m1.m_ak_nr = pos.p_aknr ) AS medata
    ;
    
  END $$ LANGUAGE plpgsql;
--

-- SELECT TSystem.views__Wawi_Eingangsrechnung__recreate();
